/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialFluidRecipeBuilder
extends AbstractRecipeBuilder<MaterialFluidRecipeBuilder> {
    private final MaterialVariantId outputId;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int temperature = -1;
    @Nullable
    private MaterialVariantId inputId;

    public MaterialFluidRecipeBuilder setFluidAndTemp(FluidStack fluidStack) {
        this.fluid = FluidIngredient.of(fluidStack);
        if (this.temperature == -1) {
            this.temperature = FluidVariantAttributes.getTemperature((FluidVariant)fluidStack.getType()) - 300;
        }
        return this;
    }

    public MaterialFluidRecipeBuilder setFluid(class_6862<class_3611> tagIn, long amount) {
        this.setFluid(FluidIngredient.of(tagIn, amount));
        return this;
    }

    @Override
    public void save(Consumer<class_2444> consumer) {
        this.save(consumer, this.outputId.getId());
    }

    @Override
    public void save(Consumer<class_2444> consumer, class_2960 id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Material fluid recipes require a fluid input");
        }
        if (this.temperature < 0) {
            throw new IllegalStateException("Temperature is too low, must be at least 0");
        }
        class_2960 advancementId = this.buildOptionalAdvancement(id, "materials");
        consumer.accept(new Result(id, advancementId));
    }

    private MaterialFluidRecipeBuilder(MaterialVariantId outputId) {
        this.outputId = outputId;
    }

    public static MaterialFluidRecipeBuilder material(MaterialVariantId outputId) {
        return new MaterialFluidRecipeBuilder(outputId);
    }

    public MaterialFluidRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public MaterialFluidRecipeBuilder setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public MaterialFluidRecipeBuilder setInputId(@Nullable MaterialVariantId inputId) {
        this.inputId = inputId;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable class_2960 ID, class_2960 advancementID) {
            super(ID, advancementID);
        }

        public void method_10416(JsonObject json) {
            if (MaterialFluidRecipeBuilder.this.inputId != null) {
                json.addProperty("input", MaterialFluidRecipeBuilder.this.inputId.toString());
            }
            json.add("fluid", MaterialFluidRecipeBuilder.this.fluid.serialize());
            json.addProperty("temperature", (Number)MaterialFluidRecipeBuilder.this.temperature);
            json.addProperty("output", MaterialFluidRecipeBuilder.this.outputId.toString());
        }

        public class_1865<?> method_17800() {
            return (class_1865)TinkerSmeltery.materialFluidRecipe.get();
        }
    }
}

